(*| 11:31 30/04/1991 *)
PROGRAM DIS8048;

USES Crt,StdTypes,DisUtils;

TYPE
  FullCodeType = String[10];

CONST
  MaxNewLineCode = 9;
  NewLineCodes : ARRAY[0..MaxNewLineCode] OF Integer =
   ($083,$093,$004,$024,$044,$064,$084,$0A4,$0C4,$0E4);


  FullRegCodes : ARRAY[0..$F] OF FullCodeType =
   ('','INC  R0','XCH  A,R0','',
    'ORL  A,R0','ANL  A,R0','ADD  A,R0','ADDC A,R0',
    '','','MOV  R0,A','MOV  R0,#',
    'DEC  R0','XRL A,R0','DJNZ R0,','MOV  A,R0');


  Opcodes00 : ARRAY[0..$0F] OF FullCodeType =
   ('NOP ','****','','','','','','',
    'INS  A,BUS','IN   A,P1','IN   A,P2','****',
    'MOVD A,P4','MOVD A,P5','MOVD A,P6','MOVD A,P7');

  Opcodes30 : ARRAY[0..$0F] OF FullCodeType =
   ('XCHD A,@R0','XCHD A,@R1','','','','','','',
    '****','OUTL P1,A','OUTL P2,A','****',
    'MOVD P4,A','MOVD P5,A','MOVD P6,A','MOVD P7,A');

  Opcodes80 : ARRAY[0..$0F] OF FullCodeType =
   ('MOVX A,@R0','MOVX A,@R1','','','','','','',
    'ORL  P0,#','ORL  P1,#','ORL  P2,#','****',
    'ORLD P4,A','ORLD P5,A','ORLD P6,A ','ORLD P7,A');

  Opcodes90 : ARRAY[0..$0F] OF FullCodeType =
   ('MOVX @R0,A','MOVX @R1,A','','','','','','',
    'ANL  P0,#','ANL  P1,#','ANL  P2,#','****',
    'ANLD P4,A','ANLD P5,A','ANLD P6,A','ANLD P7,A');

  FullOrdCodes : ARRAY[0..15,2..7] OF FullCodeType =
   (('OUTL BUS,A','ADD  A,#','JMP  ','EN   I','****','DEC  A'),
    ('JB0 ','ADDC A,#','CALL ','DIS  I','JTF  ','INC  A'),
    ('****','MOV  A,#','JMP  ','EN   TCNTI','JNT0 ','CLR  A'),
    ('JB1 ','****','CALL ','DIS  TCNTI','JT0  ','CPL  A'),
    ('MOV  A,T','ORL  A,#','JMP ','STRT CNT','JNT1 ','SWAP A'),
    ('JB2 ','ANL A,#','CALL ','STRT T','JT1  ','DA   A'),
    ('MOV  T,A','****','JMP  ','STOP TCNT','****','RRC  A'),
    ('JB3 ','****','CALL ','ENT0 CLK','JF1  ','RR   A'),
    ('****','RET ','JMP  ','CLR  F0','JNI  ','****'),
    ('JB4 ','RETR','CALL ','CPL  F0','JNZ  ','CLR  C'),
    ('****','MOVP A,@A','JMP  ','CLR  F1','****','CPL  C'),
    ('JB5 ','JMPP @A','CALL ','CPL  F1','JF0  ','****'),
    ('****','****','JMP ','SEL  RB0','JZ   ','MOV  A,PSW'),
    ('JB6 ','XRL  A,#','CALL ','SEL  RB1','****','MOV  PSW,A'),
    ('****','MOVP3 A,@A','JMP  ','SEL  MB0','JNC  ','RL   A'),
    ('JB7 ','****','CALL ','SEL  MB1','JC   ','RLC  A'));

  MaxInvalidCode = 25;

  InvalidCodes : ARRAY[0..MaxInvalidCode] OF Integer =
   ($001,$006,$00B,$022,$033,$038,$03B,$063,$066,
    $073,$082,$087,$08B,$09B,$0A2,$0A6,$0B7,$0C0,
    $0C1,$0C2,$0C3,$0D6,$0E0,$0E1,$0E2,$0F3);

FUNCTION BlankLineNeeded(OpCode: Byte): Boolean;
VAR
  I: Integer;
  B: Boolean;
BEGIN
  B:=False;
  FOR I:=0 TO MaxNewLineCode DO
    IF NewLineCodes[I]=OpCode THEN
      B:=True;
  BlankLineNeeded:=B;
END;  { BlankLineNeeded }

PROCEDURE ProcessData(Pass: Integer);
VAR
  ThisData:Word;
  I,DataBytes,BytesOnLine: Integer;
  InAscii,ExitLoop: Boolean;
BEGIN
  NeedBlankLine:=False;
  DataBytes:=1;
  IF NOT (Style IN [WordStyle]) THEN
    OpCodeString:='DB     '
  ELSE BEGIN
    OpCodeString:='DW     ';
    DataBytes:=2;
  END;
  BytesOnLine:=0;
  InAscii:=False;
  ExitLoop:=False;
  REPEAT
    ThisData:=0;
    FOR I:=1 TO DataBytes DO
      ThisData:=ThisData * 256 + GetNextByte;
    IF (Style=TableStyle) AND (Pass <> 2) THEN
      AddLabel(ThisData  + (CurrentAddress AND $F00),Location);
    IF Style=TableStyle THEN
      OpCodeString:=OpCodeString + 'L'
                 + HexString(ThisData + (CurrentAddress AND $F00),4) + ','
    ELSE IF ((ThisData <> $27) AND (ThisData >= $20)
                               AND (ThisData < $7B)) THEN BEGIN
      IF NOT InAscii THEN
        OpCodeString:=OpCodeString + #$27 + CHR(ThisData) + #$27 + ','
      ELSE BEGIN
        DELETE(OpCodeString,Length(OpCodeString)-1,2);
        OpCodeString:=OpCodeString + CHR(ThisData) + #$27 + ','
      END;
      InAscii:=True;
    END ELSE BEGIN
      OpCodeString:=OpCodeString + '0' + HexString(ThisData,2*DataBytes)
                                 + 'H,';
      InAscii:=False;
    END;
    INC(BytesOnLine);
    IF (BytesOnLine=ByteWidth) OR (CurrentAddress=SeqValue) THEN
      ExitLoop:=True;
    IF (Pass = 2) AND (CurrentAddress=NextLabelValue) THEN
      ExitLoop:=True;
  UNTIL ExitLoop;
  DELETE(OpCodeString,Length(OpCodeString),1);
END;

PROCEDURE ProcessOpCode(Pass:Integer);
VAR
  DataByte,ThisByte,LoByte,MidByte,HiByte: Byte;
  ThisData: Word;
  I: Integer;
  AMC: String[5];
BEGIN
  ThisByte:=GetNextByte;
(*
  IF ThisByte = $A0 THEN
    Write('BUG');
*)
  IF NOT NeedBlankLine THEN
    NeedBlankLine:=BlankLineNeeded(ThisByte);
  OpCodeString:='';
  NumOfDataBytes:=0;
  OpCodeAddressMode:=Implied;
  FOR I := 0 TO MaxInvalidCode DO
    IF ThisByte = InvalidCodes[I] THEN BEGIN
      OpCodeString:='****';
      NumOfDataBytes:=0;
    END;
  IF Length(OpCodeString) = 0 THEN BEGIN
    LoByte:=ThisByte AND $F;
    MidByte:=ThisByte AND $1F;
    HiByte:=(ThisByte AND $F0) SHR 4;
    IF (LoByte IN [2..7]) THEN BEGIN
      OpCodeString:=FullOrdCodes[HiByte,LoByte];
      CASE MidByte OF
        $04,
        $14 : BEGIN
                NumOfDataBytes:=1;
                OpCodeAddressMode:=Page48;
              END;
        $06,
        $12,
        $16 : BEGIN
                NumOfDataBytes:=1;
                OpCodeAddressMode:=Relative;
              END;
      END;
    END ELSE BEGIN
      OpCodeString:=FullRegCodes[HiByte];
      IF Length(OpCodeString) > 0 THEN BEGIN
        I:=POS('R0',OpCodeString);
        INC(I);
        OpCodeString[I]:=CHR(ORD(OpCodeString[I])+ (LoByte AND 7));
        DEC(I);
        IF LoByte < 2 THEN
          INSERT('@',OpCodeString,I);
      END;
      CASE HiByte OF
        $0 : OpCodeString:=OpCodes00[LoByte];
        $3 : OpCodeString:=OpCodes30[LoByte];
        $8 : OpCodeString:=OpCodes80[LoByte];
        $9 : OpCodeString:=OpCodes90[LoByte];
        $E : BEGIN
               NumOfDataBytes:=1;
               OpCodeAddressMode:=Relative;
             END;
      END;
    END;
    IF OpCodeString[Length(OpCodeString)]='#' THEN BEGIN
      NumOfDataBytes:=1;
      OpCodeAddressMode:=Immediate;
    END;
  END;
  IF NumOfDataBytes > 0 THEN BEGIN
    ThisData:=0;
    FOR I:=1 TO NumOfDataBytes DO BEGIN
      DataByte:=GetNextByte;
      ThisData:=(ThisData SHL 8) + DataByte;
    END;
    IF (OpCodeAddressMode = Page48) THEN
      ThisData:=ThisData + ((HiByte AND $E) SHL 7)
    ELSE IF (OpCodeAddressMode = Relative) THEN
      ThisData:=ThisData + (CurrentAddress AND $F00);
    IF (Pass <> 2) THEN BEGIN
      IF (OpCodeAddressMode = Relative) THEN BEGIN
        AddLabel(ThisData,Location);
      END ELSE IF (OpCodeAddressMode = Page48) THEN
        AddLabel(ThisData,Location)
    END;
    IF Pass <> 1 THEN BEGIN
      IF OpCodeAddressMode = Immediate THEN
        OpCodeString:=OpCodeString + '0';
      IF (OpCodeAddressMode = Page48) OR (OpCodeAddressMode = Relative) THEN
        OpCodeString:=OpCodeString + 'L' + HexString(ThisData,4)
      ELSE
        OpCodeString:=OpCodeString + COPY(DataString,9,2*NumOfDataBytes);
      IF OpCodeAddressMode = Immediate THEN
        OpCodeString:=OpCodeString + 'H';
    END;
  END;
END;  { ProcessOpCode }

PROCEDURE ProcessFile(Pass:Integer);
VAR
  I: Integer;
  FirstByte: Byte;
  ThisLine: LineString;
  LineNum: Integer;
BEGIN
  Writeln('Pass ',Pass);
  IF Pass <> 2 THEN
    HiLabel:=1;
  IF Pass <> 1 THEN BEGIN
    IF NOT QuietScreen THEN
      Writeln('':32,'ORG   ',HexString(StartAddress,4),'H');
    IF SaveToDisk THEN
      Writeln(AsmFile,'':8,'ORG   ',HexString(StartAddress,4),'H');
  END;
  Nextlabel:=1;
  NextLabelValue:=LongInt(Labels[1].Value);
  BufPtr:=ByteBuf;
  LineNum:=0;
  CurrentAddress:=StartAddress;
  EndOfByteFile:=False;
  NeedBlankLine:=False;
  Style:=CodeStyle;
  NextStyle:=CodeStyle;
  ByteWidth:=8;
  IF SeqExists THEN BEGIN
    Reset(SeqFile);
    NextSeq;
  END;
  REPEAT
    IF SeqExists AND (CurrentAddress >= SeqValue) THEN BEGIN
{                 AND (NOT EOF(SeqFile)) THEN BEGIN}
      DoBlankLine(LineNum);
      IF NextStyle = Remark THEN
        InsertRemark(LineNum)
      ELSE BEGIN
        Style:=NextStyle;
        ByteWidth:=NextByteWidth;
      END;
      NextSeq;
    END;
    IF Pass <> 1 THEN
      InsertLabel(LineNum);
    DataString:=HexString(CurrentAddress,4) + '  ';
    IF Style=CodeStyle THEN
      ProcessOpCode(Pass)
    ELSE
      ProcessData(Pass);
(*  IF Pass <> 2 THEN
      Writeln(DataString);*)
    IF Pass <> 1 THEN BEGIN
      ThisLine:=COPY(DataString + '        ',1,12) + '                    '
                                + OpCodeString;
      IF NOT QuietScreen THEN BEGIN
        Writeln(ThisLine);
        INC(LineNum);
      END;
      IF SaveToDisk THEN
        Writeln(AsmFile,'':8,OpCodeString);
      IF NeedBlankLine THEN BEGIN
        DoBlankLine(LineNum);
        NeedBlankLine:=False;
      END;
      IF LineNum > 20 THEN BEGIN
        IF NOT SaveToDisk THEN
          IF ReadKey=#$1B THEN BEGIN
            ShowLabels;
            HALT;
          END;
        LineNum:=0;
      END;
    END;
  UNTIL EndOfByteFile;
  IF Pass <> 2 THEN
    Writeln(HiLabel-1,' labels');
  IF Pass <> 1 THEN BEGIN
    IF NOT QuietScreen THEN
      Writeln('':32,'END');
    IF SaveToDisk THEN
      Writeln(AsmFile,'':8,'END');
  END;
  Writeln;
END;  { ProcessFile }

BEGIN
  StartAddress:=$0000;
  IF ParamCount > 0 THEN
    ByteFileName:=ParamStr(1)
  ELSE
    ByteFileName:='T7E.BIN';
  OpenSeqFile;
  Write('Disassembler by B Whitnall, V1.0, May 1990  ');
  Writeln('; 8048 ',ByteFileName);
  Writeln;
  Write('Save to Disk, Y/N ? ');
  SaveToDisk:=(UpCase(ReadKey)='Y');
  Writeln;
  QuietScreen:=False;
  IF SaveToDisk THEN BEGIN
    Write('Quiet Screen, Y/N ? ');
    QuietScreen:=(UpCase(ReadKey)='Y');
    Writeln;
  END;
  Writeln;
  ReadFileToBuf;
  EndAddress:=StartAddress + ByteFileSize;
  IF SaveToDisk THEN
    OpenAsmFile;
  FOR Pass:=1 TO 2 DO
    ProcessFile(Pass);
  IF SeqExists THEN
    Close(SeqFile);
  IF SaveToDisk THEN
    Close(AsmFile);
END.
